<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('username', 'email', 'password', 'first_name', 'last_name', 'email_verified_at', 'mobile', 'status', 'current_company', 'current_branch', 'user_type', 'lang', 'last_login');
    protected $hidden = array('password');

    public function appClient()
    {
        return $this->hasOne('App\Models\AppClient');
    }

}